/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionInterceptor
extends DelegateProcessor {
    private static final transient Log LOG = LogFactory.getLog(TransactionInterceptor.class);
    private final TransactionTemplate transactionTemplate;

    public TransactionInterceptor(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void process(final Exchange exchange) {
        LOG.info("transaction begin");
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    TransactionInterceptor.this.processNext(exchange);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException(e);
                }
            }
        });
        LOG.info("transaction commit");
    }

    public String toString() {
        return "TransactionInterceptor:" + this.propagationBehaviorToString(this.transactionTemplate.getPropagationBehavior()) + "[" + this.getProcessor() + "]";
    }

    private String propagationBehaviorToString(int propagationBehavior) {
        String rc;
        switch (propagationBehavior) {
            case 2: {
                rc = "PROPAGATION_MANDATORY";
                break;
            }
            case 6: {
                rc = "PROPAGATION_NESTED";
                break;
            }
            case 5: {
                rc = "PROPAGATION_NEVER";
                break;
            }
            case 4: {
                rc = "PROPAGATION_NOT_SUPPORTED";
                break;
            }
            case 0: {
                rc = "PROPAGATION_REQUIRED";
                break;
            }
            case 3: {
                rc = "PROPAGATION_REQUIRES_NEW";
                break;
            }
            case 1: {
                rc = "PROPAGATION_SUPPORTS";
                break;
            }
            default: {
                rc = "UNKOWN";
            }
        }
        return rc;
    }
}

