/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class Splitter
extends ServiceSupport
implements Processor {
    private final Processor processor;
    private final Expression expression;

    public Splitter(Expression expression, Processor destination) {
        this.processor = destination;
        this.expression = expression;
        ObjectHelper.notNull(destination, "destination");
        ObjectHelper.notNull(expression, "expression");
    }

    public String toString() {
        return "Splitter[on: " + this.expression + " to: " + this.processor + "]";
    }

    public void process(Exchange exchange) throws Exception {
        Object value = this.expression.evaluate(exchange);
        Iterator iter = ObjectConverter.iterator(value);
        while (iter.hasNext()) {
            Object part = iter.next();
            Exchange newExchange = exchange.copy();
            newExchange.getIn().setBody(part);
            this.processor.process(newExchange);
        }
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processor);
    }
}

