/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Serializable;
import java.util.Random;

public class RedeliveryPolicy
implements Cloneable,
Serializable {
    protected static transient Random randomNumberGenerator;
    protected int maximumRedeliveries = 6;
    protected long initialRedeliveryDelay = 1000L;
    protected double backOffMultiplier = 2.0;
    protected boolean useExponentialBackOff;
    protected double collisionAvoidanceFactor = 0.15;
    protected boolean useCollisionAvoidance;

    public String toString() {
        return "RedeliveryPolicy[maximumRedeliveries=" + this.maximumRedeliveries + "]";
    }

    public RedeliveryPolicy copy() {
        try {
            return (RedeliveryPolicy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: " + e, e);
        }
    }

    public boolean shouldRedeliver(int redeliveryCounter) {
        return redeliveryCounter < this.getMaximumRedeliveries();
    }

    public RedeliveryPolicy maximumRedeliveries(int maximumRedeliveries) {
        this.setMaximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public RedeliveryPolicy initialRedeliveryDelay(long initialRedeliveryDelay) {
        this.setInitialRedeliveryDelay(initialRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicy useCollisionAvoidance() {
        this.setUseCollisionAvoidance(true);
        return this;
    }

    public RedeliveryPolicy useExponentialBackOff() {
        this.setUseExponentialBackOff(true);
        return this;
    }

    public RedeliveryPolicy backOffMultiplier(double multiplier) {
        this.useExponentialBackOff();
        this.setBackOffMultiplier(multiplier);
        return this;
    }

    public RedeliveryPolicy collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.useCollisionAvoidance();
        this.setCollisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public short getCollisionAvoidancePercent() {
        return (short)Math.round(this.collisionAvoidanceFactor * 100.0);
    }

    public void setCollisionAvoidancePercent(double collisionAvoidancePercent) {
        this.collisionAvoidanceFactor = collisionAvoidancePercent * 0.01;
    }

    public double getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public long getInitialRedeliveryDelay() {
        return this.initialRedeliveryDelay;
    }

    public void setInitialRedeliveryDelay(long initialRedeliveryDelay) {
        this.initialRedeliveryDelay = initialRedeliveryDelay;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public long getRedeliveryDelay(long previousDelay) {
        long redeliveryDelay = previousDelay == 0L ? this.initialRedeliveryDelay : (this.useExponentialBackOff && this.backOffMultiplier > 1.0 ? Math.round(this.backOffMultiplier * (double)previousDelay) : previousDelay);
        if (this.useCollisionAvoidance) {
            Random random = RedeliveryPolicy.getRandomNumberGenerator();
            double variance = (random.nextBoolean() ? this.collisionAvoidanceFactor : -this.collisionAvoidanceFactor) * random.nextDouble();
            redeliveryDelay = (long)((double)redeliveryDelay + (double)redeliveryDelay * variance);
        }
        return redeliveryDelay;
    }

    public boolean isUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(boolean useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    protected static synchronized Random getRandomNumberGenerator() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
        return randomNumberGenerator;
    }
}

