/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline
extends MulticastProcessor
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(Pipeline.class);

    public Pipeline(Collection<Processor> processors) {
        super(processors);
    }

    public static Processor newInstance(List<Processor> processors) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        return new Pipeline(processors);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Exchange nextExchange = exchange;
        boolean first = true;
        for (Processor producer : this.getProcessors()) {
            if (first) {
                first = false;
            } else {
                nextExchange = this.createNextExchange(producer, nextExchange);
            }
            producer.process(nextExchange);
        }
    }

    protected Exchange createNextExchange(Processor producer, Exchange previousExchange) {
        Exchange answer = this.copyExchangeStrategy(previousExchange);
        Object output = previousExchange.getOut().getBody();
        Message in = answer.getIn();
        if (output != null) {
            in.setBody(output);
        } else {
            Object previousInBody = previousExchange.getIn().getBody();
            if (in.getBody() == null && previousInBody != null) {
                LOG.warn("Bad exchange implementation; the copy() method did not copy across the in body: " + previousExchange + " of type: " + previousExchange.getClass());
                in.setBody(previousInBody);
            }
        }
        return answer;
    }

    protected Exchange copyExchangeStrategy(Exchange exchange) {
        return exchange.copy();
    }

    @Override
    public String toString() {
        return "Pipeline" + this.getProcessors();
    }
}

