/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastProcessor
extends ServiceSupport
implements Processor {
    private Collection<Processor> processors;

    public MulticastProcessor(Collection<Processor> processors) {
        this.processors = processors;
    }

    public static <E extends Exchange> Collection<Processor> toProducers(Collection<Endpoint> endpoints) throws Exception {
        ArrayList<Processor> answer = new ArrayList<Processor>();
        for (Endpoint endpoint : endpoints) {
            answer.add(endpoint.createProducer());
        }
        return answer;
    }

    public String toString() {
        return "Multicast" + this.getProcessors();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        for (Processor producer : this.processors) {
            Exchange copy = this.copyExchangeStrategy(producer, exchange);
            producer.process(copy);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processors);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processors);
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    protected Exchange copyExchangeStrategy(Processor processor, Exchange exchange) {
        return exchange.copy();
    }
}

