/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.processor.Resequencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="resequencer")
public class ResequencerType
extends ProcessorType {
    @XmlElementRef
    private List<InterceptorType> interceptors = new ArrayList<InterceptorType>();
    @XmlElementRef
    private List<ExpressionType> expressions = new ArrayList<ExpressionType>();
    @XmlElementRef
    private List<ProcessorType> outputs = new ArrayList<ProcessorType>();
    @XmlTransient
    private List<Expression> expressionList;

    public ResequencerType() {
    }

    public ResequencerType(List<Expression> expressions) {
        this.expressionList = expressions;
    }

    public String toString() {
        return "Resequencer[ " + this.getExpressions() + " -> " + this.getOutputs() + "]";
    }

    public List<ExpressionType> getExpressions() {
        return this.expressions;
    }

    @Override
    public List<InterceptorType> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<InterceptorType> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public List<ProcessorType> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorType> outputs) {
        this.outputs = outputs;
    }

    @Override
    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        Endpoint from = routeContext.getEndpoint();
        final Processor processor = routeContext.createProcessor(this);
        Resequencer resequencer = new Resequencer(from, processor, this.resolveExpressionList(routeContext));
        Route<Exchange> route = new Route<Exchange>(from, new Service[]{resequencer}){

            @Override
            public String toString() {
                return "ResequencerRoute[" + this.getEndpoint() + " -> " + processor + "]";
            }
        };
        routes.add(route);
    }

    private List<Expression> resolveExpressionList(RouteContext routeContext) {
        if (this.expressionList == null) {
            this.expressionList = new ArrayList<Expression>();
            for (ExpressionType expression : this.expressions) {
                this.expressionList.add(expression.createExpression(routeContext));
            }
        }
        if (this.expressionList.isEmpty()) {
            throw new IllegalArgumentException("No expressions configured for: " + this);
        }
        return this.expressionList;
    }
}

