/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.RouteContext;

@XmlRootElement(name="from")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FromType {
    @XmlAttribute
    private String uri;
    @XmlAttribute
    private String ref;
    @XmlTransient
    private Endpoint endpoint;

    public FromType() {
    }

    public FromType(String uri) {
        this.setUri(uri);
    }

    public FromType(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        return "From[" + FromType.description(this.getUri(), this.getRef(), this.getEndpoint()) + "]";
    }

    public Endpoint resolveEndpoint(RouteContext context) {
        if (this.endpoint == null) {
            this.endpoint = context.resolveEndpoint(this.getUri(), this.getRef());
        }
        return this.endpoint;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected static String description(String uri, String ref, Endpoint endpoint) {
        if (endpoint != null) {
            return endpoint.getEndpointUri();
        }
        if (uri != null) {
            return uri;
        }
        if (ref != null) {
            return "ref:" + ref;
        }
        return "no uri or ref supplied!";
    }
}

