/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Collection;
import javax.management.JMException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.InstrumentationAgent;
import org.apache.camel.LifecycleStrategy;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.management.CamelNamingStrategy;
import org.apache.camel.management.ManagedEndpoint;
import org.apache.camel.management.ManagedRoute;
import org.apache.camel.management.ManagedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationLifecycleStrategy
implements LifecycleStrategy {
    InstrumentationAgent agent;
    CamelNamingStrategy naming;

    public InstrumentationLifecycleStrategy(InstrumentationAgent agent) {
        this.agent = agent;
        this.naming = new CamelNamingStrategy(agent.getMBeanServer().getDefaultDomain());
    }

    @Override
    public void onContextCreate(CamelContext context) {
        if (context instanceof DefaultCamelContext) {
            try {
                DefaultCamelContext dc = (DefaultCamelContext)context;
                ManagedService ms = new ManagedService(dc);
                this.agent.register(ms, this.naming.getObjectName(dc));
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onEndpointAdd(Endpoint endpoint) {
        try {
            ManagedEndpoint me = new ManagedEndpoint(endpoint);
            this.agent.register(me, this.naming.getObjectName(me));
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
        for (Route route : routes) {
            try {
                ManagedRoute mr = new ManagedRoute(route);
                this.agent.register(mr, this.naming.getObjectName(mr));
            }
            catch (JMException e) {}
        }
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service) {
        if (service instanceof ServiceSupport) {
            try {
                ManagedService ms = new ManagedService((ServiceSupport)service);
                this.agent.register(ms, this.naming.getObjectName(context, ms));
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
    }
}

