/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.juel;

import de.odysseus.el.util.SimpleContext;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.ExpressionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuelExpression
extends ExpressionSupport<Exchange> {
    private final String expression;
    private final Class<?> type;
    private ExpressionFactory expressionFactory;

    public JuelExpression(String expression, Class<?> type) {
        this.expression = expression;
        this.type = type;
    }

    public static JuelExpression el(String expression) {
        return new JuelExpression(expression, Object.class);
    }

    @Override
    public Object evaluate(Exchange exchange) {
        ELContext context = this.populateContext(this.createContext(), exchange);
        ValueExpression valueExpression = this.getExpressionFactory().createValueExpression(context, this.expression, this.type);
        return valueExpression.getValue(context);
    }

    public ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            this.expressionFactory = ExpressionFactory.newInstance();
        }
        return this.expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    protected ELContext populateContext(ELContext context, Exchange exchange) {
        this.setVariable(context, "exchange", exchange, Exchange.class);
        this.setVariable(context, "in", exchange.getIn(), Message.class);
        this.setVariable(context, "out", exchange.getOut(), Message.class);
        return context;
    }

    protected void setVariable(ELContext context, String name, Object value, Class<?> type) {
        ValueExpression valueExpression = this.getExpressionFactory().createValueExpression(value, type);
        SimpleContext simpleContext = (SimpleContext)context;
        simpleContext.setVariable(name, valueExpression);
    }

    protected ELContext createContext() {
        return new SimpleContext();
    }

    @Override
    protected String assertionFailureMessage(Exchange exchange) {
        return this.expression;
    }
}

