/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Service;
import org.apache.camel.util.ServiceHelper;

public abstract class ServiceSupport
implements Service {
    private static int threadCounter;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stopping = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private Collection childServices;

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            if (this.childServices != null) {
                ServiceHelper.startServices(this.childServices);
            }
            this.doStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.started.get() && this.stopping.compareAndSet(false, true)) {
            try {
                this.doStop();
            }
            finally {
                if (this.childServices != null) {
                    ServiceHelper.stopServices(this.childServices);
                }
                this.stopped.set(true);
                this.started.set(false);
                this.stopping.set(false);
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    protected String getThreadName(String prefix) {
        return prefix + " thread:" + ServiceSupport.nextThreadCounter();
    }

    protected static synchronized int nextThreadCounter() {
        return ++threadCounter;
    }

    protected void addChildService(Object childService) {
        if (this.childServices == null) {
            this.childServices = new ArrayList();
        }
        this.childServices.add(childService);
    }

    protected boolean removeChildService(Object childService) {
        if (this.childServices != null) {
            return this.childServices.remove(childService);
        }
        return false;
    }
}

