/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.LifecycleStrategy;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultComponentResolver;
import org.apache.camel.impl.DefaultExchangeConverter;
import org.apache.camel.impl.DefaultLanguageResolver;
import org.apache.camel.impl.DefaultLifecycleStrategy;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.impl.ReflectionInjector;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.ExchangeConverter;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.FactoryFinder;
import org.apache.camel.util.NoFactoryAvailableException;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCamelContext
extends ServiceSupport
implements CamelContext,
Service {
    private Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    private Map<String, Component> components = new HashMap<String, Component>();
    private List<Route> routes;
    private List<Service> servicesToClose = new ArrayList<Service>();
    private TypeConverter typeConverter;
    private ExchangeConverter exchangeConverter;
    private Injector injector;
    private ComponentResolver componentResolver;
    private boolean autoCreateComponents = true;
    private LanguageResolver languageResolver = new DefaultLanguageResolver();
    private Registry registry;
    private LifecycleStrategy lifecycleStrategy = new DefaultLifecycleStrategy();

    public DefaultCamelContext() {
    }

    public DefaultCamelContext(Context jndiContext) {
        this(new JndiRegistry(jndiContext));
    }

    public DefaultCamelContext(Registry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(String componentName, Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        Map<String, Component> map = this.components;
        synchronized (map) {
            if (this.components.containsKey(componentName)) {
                throw new IllegalArgumentException("Component previously added: " + componentName);
            }
            component.setCamelContext(this);
            this.components.put(componentName, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponent(String name) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(name);
            if (component == null && this.autoCreateComponents) {
                try {
                    component = this.getComponentResolver().resolveComponent(name, this);
                    if (component != null) {
                        this.addComponent(name, component);
                        if (this.isStarted()) {
                            ServiceHelper.startServices(component);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Could not auto create component: " + name, e);
                }
            }
            return component;
        }
    }

    @Override
    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        Component component = this.getComponent(name);
        if (componentType.isInstance(component)) {
            return (T)((Component)componentType.cast(component));
        }
        throw new IllegalArgumentException("The component is not of type: " + componentType + " but is: " + component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component removeComponent(String componentName) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            return this.components.remove(componentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getOrCreateComponent(String componentName, Callable<Component> factory) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(componentName);
            if (component == null) {
                try {
                    component = factory.call();
                    if (component == null) {
                        throw new RuntimeCamelException("Factory failed to create the " + componentName + " component, it returned null.");
                    }
                    this.components.put(componentName, component);
                    component.setCamelContext(this);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Factory failed to create the " + componentName + " component", e);
                }
            }
            return component;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> getSingletonEndpoints() {
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            return new ArrayList<Endpoint>(this.endpoints.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint addSingletonEndpoint(String uri, Endpoint endpoint) throws Exception {
        Endpoint oldEndpoint;
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            ServiceHelper.startServices(endpoint);
            oldEndpoint = this.endpoints.remove(uri);
            this.endpoints.put(uri, endpoint);
            ServiceHelper.stopServices(oldEndpoint);
        }
        return oldEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint removeSingletonEndpoint(String uri) throws Exception {
        Endpoint oldEndpoint;
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            oldEndpoint = this.endpoints.remove(uri);
            ServiceHelper.stopServices(oldEndpoint);
        }
        return oldEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint getEndpoint(String uri) {
        Endpoint answer;
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            answer = this.endpoints.get(uri);
            if (answer == null) {
                try {
                    String scheme;
                    Component component;
                    String[] splitURI = ObjectHelper.splitOnCharacter(uri, ":", 2);
                    if (splitURI[1] != null && (component = this.getComponent(scheme = splitURI[0])) != null) {
                        answer = component.createEndpoint(uri);
                    }
                    if (answer == null) {
                        answer = this.createEndpoint(uri);
                    }
                    if (answer != null && answer.isSingleton()) {
                        ServiceHelper.startServices(answer);
                        this.endpoints.put(uri, answer);
                        this.lifecycleStrategy.onEndpointAdd(answer);
                    }
                }
                catch (Exception e) {
                    throw new ResolveEndpointFailedException(uri, e);
                }
            }
        }
        return answer;
    }

    @Override
    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint);
    }

    @Override
    public List<Route> getRoutes() {
        return this.routes;
    }

    @Override
    public void setRoutes(List<Route> routes) {
        this.routes = routes;
    }

    @Override
    public void addRoutes(Collection<Route> routes) throws Exception {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>(routes);
        } else {
            this.routes.addAll(routes);
        }
        this.lifecycleStrategy.onRoutesAdd(routes);
        if (this.isStarted()) {
            this.startRoutes(routes);
        }
    }

    @Override
    public void addRoutes(RouteBuilder builder) throws Exception {
        builder.setContext(this);
        this.addRoutes(builder.getRouteList());
    }

    @Override
    public Language resolveLanguage(String language) {
        return this.getLanguageResolver().resolveLanguage(language, this);
    }

    @Override
    public ExchangeConverter getExchangeConverter() {
        if (this.exchangeConverter == null) {
            this.exchangeConverter = this.createExchangeConverter();
        }
        return this.exchangeConverter;
    }

    public void setExchangeConverter(ExchangeConverter exchangeConverter) {
        this.exchangeConverter = exchangeConverter;
    }

    @Override
    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = this.createTypeConverter();
        }
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.createInjector();
        }
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public ComponentResolver getComponentResolver() {
        if (this.componentResolver == null) {
            this.componentResolver = this.createComponentResolver();
        }
        return this.componentResolver;
    }

    public void setComponentResolver(ComponentResolver componentResolver) {
        this.componentResolver = componentResolver;
    }

    public LanguageResolver getLanguageResolver() {
        return this.languageResolver;
    }

    public void setLanguageResolver(LanguageResolver languageResolver) {
        this.languageResolver = languageResolver;
    }

    public boolean isAutoCreateComponents() {
        return this.autoCreateComponents;
    }

    public void setAutoCreateComponents(boolean autoCreateComponents) {
        this.autoCreateComponents = autoCreateComponents;
    }

    @Override
    public Registry getRegistry() {
        if (this.registry == null) {
            this.registry = this.createRegistry();
        }
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public LifecycleStrategy getLifecycleStrategy() {
        return this.lifecycleStrategy;
    }

    public void setLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        this.lifecycleStrategy = lifecycleStrategy;
    }

    @Override
    protected void doStart() throws Exception {
        this.forceLazyInitialization();
        if (this.components != null) {
            for (Component component : this.components.values()) {
                ServiceHelper.startServices(component);
            }
        }
        this.startRoutes(this.routes);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.servicesToClose);
        if (this.components != null) {
            for (Component component : this.components.values()) {
                ServiceHelper.stopServices(component);
            }
        }
    }

    protected void startRoutes(Collection<Route> routeList) throws Exception {
        if (routeList != null) {
            for (Route route : routeList) {
                List<Service> services = route.getServicesForRoute();
                this.servicesToClose.addAll(services);
                ServiceHelper.startServices(services);
            }
        }
    }

    protected void forceLazyInitialization() {
        this.getExchangeConverter();
        this.getInjector();
        this.getLanguageResolver();
        this.getTypeConverter();
    }

    protected ExchangeConverter createExchangeConverter() {
        return new DefaultExchangeConverter();
    }

    protected TypeConverter createTypeConverter() {
        return new DefaultTypeConverter(this.getInjector());
    }

    protected Injector createInjector() {
        FactoryFinder finder = new FactoryFinder();
        try {
            return (Injector)finder.newInstance("Injector");
        }
        catch (NoFactoryAvailableException e) {
            return new ReflectionInjector();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeCamelException(e);
        }
        catch (IOException e) {
            throw new RuntimeCamelException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeCamelException(e);
        }
    }

    protected ComponentResolver createComponentResolver() {
        return new DefaultComponentResolver();
    }

    protected Registry createRegistry() {
        return new JndiRegistry();
    }

    protected Endpoint createEndpoint(String uri) {
        Object value = this.getRegistry().lookup(uri);
        if (value instanceof Endpoint) {
            return (Endpoint)value;
        }
        if (value instanceof Processor) {
            return new ProcessorEndpoint(uri, this, (Processor)value);
        }
        if (value != null) {
            return this.convertBeanToEndpoint(uri, value);
        }
        return null;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        throw new IllegalArgumentException("uri: " + uri + " bean: " + bean + " could not be converted to an Endpoint");
    }
}

