/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.component.xmpp.XmppExchange;
import org.jivesoftware.smack.packet.Message;

public class XmppBinding {
    public void populateXmppMessage(Message message, Exchange exchange) {
        message.setBody(exchange.getIn().getBody(String.class));
        Set<Map.Entry<String, Object>> entries = exchange.getIn().getHeaders().entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Object value;
            String name = entry.getKey();
            if (!this.shouldOutputHeader(exchange, name, value = entry.getValue())) continue;
            message.setProperty(name, value);
        }
        String id = exchange.getExchangeId();
        if (id != null) {
            message.setProperty("exchangeId", (Object)id);
        }
    }

    public Object extractBodyFromXmpp(XmppExchange exchange, Message message) {
        return message.getBody();
    }

    protected boolean shouldOutputHeader(Exchange exchange, String headerName, Object headerValue) {
        return true;
    }
}

