/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedaEndpoint<E extends Exchange>
extends DefaultEndpoint<E> {
    private BlockingQueue<E> queue;

    public SedaEndpoint(String endpointUri, Component component, BlockingQueue<E> queue) {
        super(endpointUri, component);
        this.queue = queue;
    }

    public SedaEndpoint(String uri, SedaComponent<E> component) {
        this(uri, component, component.createQueue());
    }

    @Override
    public Producer<E> createProducer() throws Exception {
        return new DefaultProducer(this){

            public void process(Exchange exchange) {
                SedaEndpoint.this.queue.add(SedaEndpoint.this.toExchangeType(exchange));
            }
        };
    }

    @Override
    public Consumer<E> createConsumer(Processor processor) throws Exception {
        return new SedaConsumer(this, processor);
    }

    @Override
    public E createExchange() {
        return (E)new DefaultExchange(this.getContext());
    }

    public BlockingQueue<E> getQueue() {
        return this.queue;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

