/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.TimeUnit;
import org.apache.camel.AlreadyStoppedException;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedaConsumer<E extends Exchange>
extends ServiceSupport
implements Consumer<E>,
Runnable {
    private static final Log LOG = LogFactory.getLog(SedaConsumer.class);
    private SedaEndpoint<E> endpoint;
    private Processor processor;
    private Thread thread;

    public SedaConsumer(SedaEndpoint<E> endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public String toString() {
        return "QueueConsumer: " + this.endpoint.getEndpointUri();
    }

    @Override
    public void run() {
        while (!this.isStopping()) {
            Exchange exchange;
            try {
                exchange = (Exchange)this.endpoint.getQueue().poll(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                break;
            }
            if (exchange == null || this.isStopping()) continue;
            try {
                this.processor.process(exchange);
            }
            catch (AlreadyStoppedException e) {
                LOG.debug("Ignoring failed message due to shutdown: " + e, e);
                break;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.thread = new Thread((Runnable)this, this.getThreadName(this.endpoint.getEndpointUri()));
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.thread.join();
    }
}

