/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssertionClause<E extends Exchange>
implements Runnable {
    private List<Predicate<E>> predicates = new ArrayList<Predicate<E>>();

    public AssertionClause<E> predicate(Predicate<E> predicate) {
        this.addPredicate(predicate);
        return this;
    }

    public ValueBuilder<E> header(String name) {
        Expression expression = ExpressionBuilder.headerExpression(name);
        return new PredicateValueBuilder(expression);
    }

    public PredicateValueBuilder body() {
        Expression expression = ExpressionBuilder.bodyExpression();
        return new PredicateValueBuilder(expression);
    }

    public <T> PredicateValueBuilder bodyAs(Class<T> type) {
        Expression expression = ExpressionBuilder.bodyExpression(type);
        return new PredicateValueBuilder(expression);
    }

    public PredicateValueBuilder outBody() {
        Expression expression = ExpressionBuilder.bodyExpression();
        return new PredicateValueBuilder(expression);
    }

    public <T> PredicateValueBuilder outBody(Class<T> type) {
        Expression expression = ExpressionBuilder.bodyExpression(type);
        return new PredicateValueBuilder(expression);
    }

    protected void applyAssertionOn(MockEndpoint endpoint, int index, E exchange) {
        for (Predicate<E> predicate : this.predicates) {
            predicate.assertMatches(endpoint.getEndpointUri() + " ", exchange);
        }
    }

    protected void addPredicate(Predicate<E> predicate) {
        this.predicates.add(predicate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PredicateValueBuilder
    extends ValueBuilder<E> {
        public PredicateValueBuilder(Expression<E> expression) {
            super(expression);
        }

        @Override
        protected Predicate<E> onNewPredicate(Predicate<E> predicate) {
            AssertionClause.this.addPredicate(predicate);
            return predicate;
        }
    }
}

