/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mina.MinaComponent;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.component.mina.MinaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaEndpoint
extends DefaultEndpoint<MinaExchange> {
    private final IoAcceptor acceptor;
    private final SocketAddress address;
    private final IoConnector connector;
    private final IoServiceConfig config;

    public MinaEndpoint(String endpointUri, MinaComponent component, SocketAddress address, IoAcceptor acceptor, IoConnector connector, IoServiceConfig config) {
        super(endpointUri, component);
        this.config = config;
        this.address = address;
        this.acceptor = acceptor;
        this.connector = connector;
    }

    @Override
    public Producer<MinaExchange> createProducer() throws Exception {
        return new MinaProducer(this);
    }

    @Override
    public Consumer<MinaExchange> createConsumer(Processor processor) throws Exception {
        return new MinaConsumer(this, processor);
    }

    @Override
    public MinaExchange createExchange() {
        return new MinaExchange(this.getContext());
    }

    public MinaExchange createExchange(IoSession session, Object object) {
        MinaExchange exchange = new MinaExchange(this.getContext());
        exchange.getIn().setBody(object);
        return exchange;
    }

    public IoAcceptor getAcceptor() {
        return this.acceptor;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public IoConnector getConnector() {
        return this.connector;
    }

    public IoServiceConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

