/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.MessageListener;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.EndpointMessageListener;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.impl.DefaultConsumer;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsConsumer
extends DefaultConsumer<JmsExchange> {
    private final AbstractMessageListenerContainer listenerContainer;

    public JmsConsumer(JmsEndpoint endpoint, Processor processor, AbstractMessageListenerContainer listenerContainer) {
        super(endpoint, processor);
        this.listenerContainer = listenerContainer;
        MessageListener messageListener = this.createMessageListener(endpoint, processor);
        this.listenerContainer.setMessageListener((Object)messageListener);
    }

    public AbstractMessageListenerContainer getListenerContainer() {
        return this.listenerContainer;
    }

    protected MessageListener createMessageListener(JmsEndpoint endpoint, Processor processor) {
        EndpointMessageListener<JmsExchange> messageListener = new EndpointMessageListener<JmsExchange>(endpoint, processor);
        messageListener.setBinding(endpoint.getBinding());
        return messageListener;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.listenerContainer.afterPropertiesSet();
        this.listenerContainer.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.listenerContainer.stop();
        this.listenerContainer.destroy();
        super.doStop();
    }
}

