/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.impl.DefaultComponent;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.xmlsoap.schemas.wsdl.http.AddressType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfComponent
extends DefaultComponent<CxfExchange> {
    private LocalTransportFactory localTransportFactory;

    public CxfComponent() {
    }

    public CxfComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint<CxfExchange> createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        URI u = new URI(remaining);
        EndpointInfo endpointInfo = new EndpointInfo(null, "http://schemas.xmlsoap.org/soap/http");
        AddressType a = new AddressType();
        a.setLocation(remaining);
        endpointInfo.addExtensor((Object)a);
        return new CxfEndpoint(uri, this, endpointInfo);
    }

    public LocalTransportFactory getLocalTransportFactory() throws BusException {
        if (this.localTransportFactory == null) {
            this.localTransportFactory = this.findLocalTransportFactory();
            if (this.localTransportFactory == null) {
                this.localTransportFactory = new LocalTransportFactory();
            }
        }
        return this.localTransportFactory;
    }

    public void setLocalTransportFactory(LocalTransportFactory localTransportFactory) {
        this.localTransportFactory = localTransportFactory;
    }

    protected LocalTransportFactory findLocalTransportFactory() throws BusException {
        Bus bus = CXFBusFactory.getDefaultBus();
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        return (LocalTransportFactory)dfm.getDestinationFactory("http://cxf.apache.org/transports/local");
    }
}

