/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.bean.DefaultParameterMappingStrategy;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanProcessor
implements Processor {
    public static final String METHOD_NAME = "org.apache.camel.MethodName";
    private static final Log LOG = LogFactory.getLog(BeanProcessor.class);
    private final Object pojo;
    private final BeanInfo beanInfo;
    private Method method;
    private String methodName;

    public BeanProcessor(Object pojo, BeanInfo beanInfo) {
        this.pojo = pojo;
        this.beanInfo = beanInfo;
    }

    public BeanProcessor(Object pojo, ParameterMappingStrategy parameterMappingStrategy) {
        this(pojo, new BeanInfo(pojo.getClass(), parameterMappingStrategy));
    }

    public BeanProcessor(Object pojo, CamelContext camelContext) {
        this(pojo, BeanProcessor.createParameterMappingStrategy(camelContext));
    }

    public static ParameterMappingStrategy createParameterMappingStrategy(CamelContext camelContext) {
        Registry registry = camelContext.getRegistry();
        ParameterMappingStrategy answer = registry.lookup(ParameterMappingStrategy.class.getName(), ParameterMappingStrategy.class);
        if (answer == null) {
            answer = new DefaultParameterMappingStrategy();
        }
        return answer;
    }

    public String toString() {
        String description = this.method != null ? " " + this.method : "";
        return "BeanProcessor[" + this.pojo + description + "]";
    }

    public void process(Exchange exchange) throws Exception {
        MethodInvocation invocation;
        Message in;
        BeanInvocation beanInvoke;
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>>> invoking method for: " + exchange);
        }
        if ((beanInvoke = (in = exchange.getIn()).getBody(BeanInvocation.class)) != null) {
            beanInvoke.invoke(this.pojo, exchange);
            return;
        }
        if (this.method != null) {
            invocation = this.beanInfo.createInvocation(this.method, this.pojo, exchange);
        } else {
            if (ObjectHelper.isNotNullAndNonEmpty(this.methodName) && ObjectHelper.isNullOrBlank(in.getHeader(METHOD_NAME, String.class))) {
                in.setHeader(METHOD_NAME, this.methodName);
            }
            invocation = this.beanInfo.createInvocation(this.pojo, exchange);
        }
        if (invocation == null) {
            throw new IllegalStateException("No method invocation could be created");
        }
        try {
            Object value = invocation.proceed();
            if (value != null) {
                exchange.getIn().setBody(value);
            }
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }
}

