/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Body;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.Message;
import org.apache.camel.Property;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanInfo {
    private static final transient Log LOG = LogFactory.getLog(BeanInfo.class);
    private Class type;
    private ParameterMappingStrategy strategy;
    private Map<String, MethodInfo> operations = new ConcurrentHashMap<String, MethodInfo>();
    private MethodInfo defaultMethod;
    private List<MethodInfo> operationsWithBody = new ArrayList<MethodInfo>();

    public BeanInfo(Class type, ParameterMappingStrategy strategy) {
        this.type = type;
        this.strategy = strategy;
        this.introspect(this.getType());
        if (this.operations.size() == 1) {
            Collection<MethodInfo> methodInfos = this.operations.values();
            Iterator<MethodInfo> i$ = methodInfos.iterator();
            while (i$.hasNext()) {
                MethodInfo methodInfo;
                this.defaultMethod = methodInfo = i$.next();
            }
        }
    }

    public Class getType() {
        return this.type;
    }

    public MethodInvocation createInvocation(Method method, Object pojo, Exchange exchange) throws RuntimeCamelException {
        MethodInfo methodInfo = this.introspect(this.type, method);
        if (methodInfo != null) {
            return methodInfo.createMethodInvocation(pojo, exchange);
        }
        return null;
    }

    public MethodInvocation createInvocation(Object pojo, Exchange exchange) throws RuntimeCamelException, AmbiguousMethodCallException {
        MethodInfo methodInfo = null;
        String name = exchange.getIn().getHeader("org.apache.camel.MethodName", String.class);
        if (name != null) {
            methodInfo = this.operations.get(name);
        }
        if (methodInfo == null) {
            methodInfo = this.chooseMethod(pojo, exchange);
        }
        if (methodInfo == null) {
            methodInfo = this.defaultMethod;
        }
        if (methodInfo != null) {
            return methodInfo.createMethodInvocation(pojo, exchange);
        }
        return null;
    }

    protected void introspect(Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!this.isValidMethod(clazz, method)) continue;
            this.introspect(clazz, method);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.introspect(superclass);
        }
    }

    protected MethodInfo introspect(Class clazz, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        Expression[] parameterExpressions = new Expression[parameterTypes.length];
        ArrayList<ParameterInfo> parameters = new ArrayList<ParameterInfo>();
        ArrayList<ParameterInfo> bodyParameters = new ArrayList<ParameterInfo>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Annotation[] parameterAnnotations = parametersAnnotations[i];
            Expression expression = this.createParameterUnmarshalExpression(clazz, method, parameterType, parameterAnnotations);
            if (expression == null) {
                if (parameterTypes.length == 1 && bodyParameters.isEmpty()) {
                    expression = ExpressionBuilder.bodyExpression(parameterType);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No expression available for method: " + method.toString() + " which already has a body so ignoring parameter: " + i + " so ignoring method");
                    }
                    return null;
                }
            }
            ParameterInfo parameterInfo = new ParameterInfo(i, parameterType, parameterAnnotations, expression);
            parameters.add(parameterInfo);
            if (!this.isPossibleBodyParameter(parameterAnnotations)) continue;
            bodyParameters.add(parameterInfo);
        }
        String opName = method.getName();
        MethodInfo methodInfo = new MethodInfo(clazz, method, parameters, bodyParameters);
        this.operations.put(opName, methodInfo);
        if (methodInfo.hasBodyParameter()) {
            this.operationsWithBody.add(methodInfo);
        }
        return methodInfo;
    }

    protected MethodInfo chooseMethod(Object pojo, Exchange exchange) throws AmbiguousMethodCallException {
        if (this.operationsWithBody.size() == 1) {
            return this.operationsWithBody.get(0);
        }
        if (!this.operationsWithBody.isEmpty()) {
            Message in = exchange.getIn();
            Object body = in.getBody();
            if (body != null) {
                Class<?> bodyType = body.getClass();
                ArrayList<MethodInfo> possibles = new ArrayList<MethodInfo>();
                for (MethodInfo methodInfo : this.operationsWithBody) {
                    if (!methodInfo.bodyParameterMatches(bodyType)) continue;
                    possibles.add(methodInfo);
                }
                if (possibles.size() == 1) {
                    return (MethodInfo)possibles.get(0);
                }
                if (possibles.isEmpty()) {
                    Object newBody = null;
                    MethodInfo matched = null;
                    for (MethodInfo methodInfo : this.operationsWithBody) {
                        Object value = ExchangeHelper.convertToType(exchange, methodInfo.getBodyParameterType(), body);
                        if (value == null) continue;
                        if (newBody != null) {
                            throw new AmbiguousMethodCallException(exchange, Arrays.asList(matched, methodInfo));
                        }
                        newBody = value;
                        matched = methodInfo;
                    }
                    if (matched != null) {
                        in.setBody(newBody);
                        return matched;
                    }
                } else {
                    throw new AmbiguousMethodCallException(exchange, possibles);
                }
            }
            return null;
        }
        return null;
    }

    protected Expression createParameterUnmarshalExpression(Class clazz, Method method, Class parameterType, Annotation[] parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            Expression answer = this.createParameterUnmarshalExpressionForAnnotation(clazz, method, parameterType, annotation);
            if (answer == null) continue;
            return answer;
        }
        return this.strategy.getDefaultParameterTypeExpression(parameterType);
    }

    protected boolean isPossibleBodyParameter(Annotation[] annotations) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Property) && !(annotation instanceof Header)) continue;
                return false;
            }
        }
        return true;
    }

    protected Expression createParameterUnmarshalExpressionForAnnotation(Class clazz, Method method, Class parameterType, Annotation annotation) {
        if (annotation instanceof Property) {
            Property propertyAnnotation = (Property)annotation;
            return ExpressionBuilder.propertyExpression(propertyAnnotation.name());
        }
        if (annotation instanceof Header) {
            Header headerAnnotation = (Header)annotation;
            return ExpressionBuilder.headerExpression(headerAnnotation.name());
        }
        if (annotation instanceof Body) {
            Body content = (Body)annotation;
            return ExpressionBuilder.bodyExpression(parameterType);
        }
        return null;
    }

    protected boolean isValidMethod(Class clazz, Method method) {
        return Modifier.isPublic(method.getModifiers());
    }
}

