/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.NoBeanAvailableException;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanComponent
extends DefaultComponent {
    private static final Log LOG = LogFactory.getLog(BeanComponent.class);
    private ParameterMappingStrategy parameterMappingStrategy;

    public ParameterMappingStrategy getParameterMappingStrategy() {
        if (this.parameterMappingStrategy == null) {
            this.parameterMappingStrategy = this.createParameterMappingStrategy();
        }
        return this.parameterMappingStrategy;
    }

    public void setParameterMappingStrategy(ParameterMappingStrategy parameterMappingStrategy) {
        this.parameterMappingStrategy = parameterMappingStrategy;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        Object bean = this.getBean(remaining);
        BeanProcessor processor = new BeanProcessor(bean, this.getParameterMappingStrategy());
        IntrospectionSupport.setProperties(processor, parameters);
        return new ProcessorEndpoint(uri, this, (Processor)processor);
    }

    public Object getBean(String remaining) throws NoBeanAvailableException {
        Registry registry = this.getCamelContext().getRegistry();
        Object bean = registry.lookup(remaining);
        if (bean == null) {
            throw new NoBeanAvailableException(remaining);
        }
        return bean;
    }

    protected ParameterMappingStrategy createParameterMappingStrategy() {
        return BeanProcessor.createParameterMappingStrategy(this.getCamelContext());
    }
}

