/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DefaultNamespaceContext
implements NamespaceContext {
    private final Map map;
    private final NamespaceContext parent;

    public DefaultNamespaceContext() {
        this(XPathFactory.newInstance());
    }

    public DefaultNamespaceContext(XPathFactory factory) {
        this.parent = factory.newXPath().getNamespaceContext();
        this.map = new HashMap();
    }

    public DefaultNamespaceContext(NamespaceContext parent, Map map) {
        this.parent = parent;
        this.map = map;
    }

    public DefaultNamespaceContext add(String prefix, String uri) {
        this.map.put(prefix, uri);
        return this;
    }

    public String getNamespaceURI(String prefix) {
        String answer = (String)this.map.get(prefix);
        if (answer == null && this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return answer;
    }

    public String getPrefix(String namespaceURI) {
        for (Map.Entry entry : this.map.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        if (this.parent != null) {
            return this.parent.getPrefix(namespaceURI);
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        HashSet<Object> set = new HashSet<Object>();
        for (Map.Entry entry : this.map.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            set.add(entry.getKey());
        }
        if (this.parent != null) {
            Iterator<Object> iter = this.parent.getPrefixes(namespaceURI);
            while (iter.hasNext()) {
                set.add(iter.next());
            }
        }
        return set.iterator();
    }

    public void setNamespacesFromDom(Element element) {
        Node parentNode = element.getParentNode();
        if (parentNode instanceof Element) {
            this.setNamespacesFromDom((Element)parentNode);
        }
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr node = (Attr)attributes.item(i);
            String name = node.getName();
            if (!name.startsWith("xmlns:")) continue;
            String prefix = name.substring("xmlns:".length());
            String uri = node.getValue();
            this.add(prefix, uri);
        }
    }
}

