/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam;

import java.util.Date;
import org.apache.camel.bam.ActivityBuilder;
import org.apache.camel.bam.ActivityLifecycle;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.rules.ActivityRules;
import org.apache.camel.bam.rules.TemporalRule;
import org.apache.camel.util.ObjectHelper;

public abstract class TimeExpression {
    private ActivityRules activityRules;
    private ActivityBuilder builder;
    private ActivityLifecycle lifecycle;

    public TimeExpression(ActivityBuilder builder, ActivityLifecycle lifecycle) {
        this.lifecycle = lifecycle;
        this.builder = builder;
        this.activityRules = builder.getActivityRules();
    }

    public boolean isActivityLifecycle(ActivityRules activityRules, ActivityLifecycle lifecycle) {
        return ObjectHelper.equals(activityRules, this.activityRules) && ObjectHelper.equals((Object)lifecycle, (Object)this.lifecycle);
    }

    public TemporalRule after(TimeExpression expression) {
        TemporalRule rule = new TemporalRule(expression, this);
        rule.getSecond().getActivityRules().addRule(rule);
        return rule;
    }

    public Date evaluate(ProcessInstance processInstance) {
        ActivityState state = processInstance.getActivityState(this.activityRules);
        if (state != null) {
            return this.evaluate(processInstance, state);
        }
        return null;
    }

    public abstract Date evaluate(ProcessInstance var1, ActivityState var2);

    public ActivityBuilder getBuilder() {
        return this.builder;
    }

    public ActivityRules getActivityRules() {
        return this.activityRules;
    }

    public ActivityLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public ActivityState getActivityState(ProcessInstance instance) {
        return instance.getActivityState(this.activityRules);
    }

    public ActivityState getOrCreateActivityState(ProcessInstance instance) {
        return instance.getOrCreateActivityState(this.activityRules);
    }
}

