/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.bam.ActivityBuilder;
import org.apache.camel.bam.model.ActivityDefinition;
import org.apache.camel.bam.model.ProcessDefinition;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.processor.ActivityMonitorEngine;
import org.apache.camel.bam.processor.JpaBamProcessor;
import org.apache.camel.bam.rules.ProcessRules;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.ObjectHelper;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessBuilder
extends RouteBuilder {
    private static int processCounter;
    private JpaTemplate jpaTemplate;
    private final TransactionTemplate transactionTemplate;
    private final String processName;
    private List<ActivityBuilder> activityBuilders = new ArrayList<ActivityBuilder>();
    private Class entityType = ProcessInstance.class;
    private ProcessRules processRules = new ProcessRules();
    private ProcessDefinition processDefinition;

    protected ProcessBuilder(JpaTemplate jpaTemplate, TransactionTemplate transactionTemplate) {
        this(jpaTemplate, transactionTemplate, ProcessBuilder.createProcessName());
    }

    protected ProcessBuilder(JpaTemplate jpaTemplate, TransactionTemplate transactionTemplate, String processName) {
        this.jpaTemplate = jpaTemplate;
        this.transactionTemplate = transactionTemplate;
        this.processName = processName;
    }

    protected static synchronized String createProcessName() {
        return "Process-" + ++processCounter;
    }

    public ActivityBuilder activity(String endpointUri) {
        return this.activity(this.endpoint(endpointUri));
    }

    public ActivityBuilder activity(Endpoint endpoint) {
        ActivityBuilder answer = new ActivityBuilder(this, endpoint);
        this.activityBuilders.add(answer);
        return answer;
    }

    public ProcessBuilder entityType(Class entityType) {
        this.entityType = entityType;
        return this;
    }

    public Processor createActivityProcessor(ActivityBuilder activityBuilder) {
        ObjectHelper.notNull(this.jpaTemplate, "jpaTemplate");
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ProcessBuilder.this.processRules.setProcessDefinition(ProcessBuilder.this.getProcessDefinition());
            }
        });
        return new JpaBamProcessor(this.getTransactionTemplate(), this.getJpaTemplate(), (Expression<Exchange>)activityBuilder.getCorrelationExpression(), activityBuilder.getActivityRules(), this.getEntityType());
    }

    public List<ActivityBuilder> getActivityBuilders() {
        return this.activityBuilders;
    }

    public Class getEntityType() {
        return this.entityType;
    }

    public JpaTemplate getJpaTemplate() {
        return this.jpaTemplate;
    }

    public void setJpaTemplate(JpaTemplate jpaTemplate) {
        this.jpaTemplate = jpaTemplate;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public ProcessRules getProcessRules() {
        return this.processRules;
    }

    public String getProcessName() {
        return this.processName;
    }

    public ProcessDefinition getProcessDefinition() {
        if (this.processDefinition == null) {
            this.processDefinition = this.findOrCreateProcessDefinition();
        }
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    @Override
    protected void populateRoutes(List<Route> routes) throws Exception {
        boolean first = true;
        for (ActivityBuilder builder : this.activityBuilders) {
            Route route = builder.createRoute();
            if (first) {
                route.getServices().add(new ActivityMonitorEngine(this.getJpaTemplate(), this.getTransactionTemplate(), this.getProcessRules()));
                first = false;
            }
            routes.add(route);
        }
    }

    public ActivityDefinition findOrCreateActivityDefinition(String activityName) {
        ProcessDefinition definition = this.getProcessDefinition();
        List list = this.jpaTemplate.find("select x from " + ActivityDefinition.class.getName() + " x where x.processDefinition = ?1 and x.name = ?2", new Object[]{definition, activityName});
        if (!list.isEmpty()) {
            return (ActivityDefinition)list.get(0);
        }
        ActivityDefinition answer = new ActivityDefinition();
        answer.setName(activityName);
        answer.setProcessDefinition(ProcessDefinition.getRefreshedProcessDefinition(this.jpaTemplate, definition));
        this.jpaTemplate.persist((Object)answer);
        return answer;
    }

    protected ProcessDefinition findOrCreateProcessDefinition() {
        List list = this.jpaTemplate.find("select x from " + ProcessDefinition.class.getName() + " x where x.name = ?1", new Object[]{this.processName});
        if (!list.isEmpty()) {
            return (ProcessDefinition)list.get(0);
        }
        ProcessDefinition answer = new ProcessDefinition();
        answer.setName(this.processName);
        this.jpaTemplate.persist((Object)answer);
        return answer;
    }
}

