/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class Time {
    private long number;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public static Time millis(long value) {
        return new Time(value, TimeUnit.MILLISECONDS);
    }

    public static Time micros(long value) {
        return new Time(value, TimeUnit.MICROSECONDS);
    }

    public static Time nanos(long value) {
        return new Time(value, TimeUnit.NANOSECONDS);
    }

    public static Time seconds(long value) {
        return new Time(value, TimeUnit.SECONDS);
    }

    public static Time minutes(long value) {
        return new Time(Time.minutesAsSeconds(value), TimeUnit.MILLISECONDS);
    }

    public static Time hours(long value) {
        return new Time(Time.hoursAsSeconds(value), TimeUnit.MILLISECONDS);
    }

    public static Time days(long value) {
        return new Time(Time.daysAsSeconds(value), TimeUnit.MILLISECONDS);
    }

    public Time(long number, TimeUnit timeUnit) {
        this.number = number;
        this.timeUnit = timeUnit;
    }

    public long toMillis() {
        return this.timeUnit.toMillis(this.number);
    }

    public Date toDate() {
        return new Date(this.toMillis());
    }

    public long getNumber() {
        return this.number;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    protected static long minutesAsSeconds(long value) {
        return value * 60L;
    }

    protected static long hoursAsSeconds(long value) {
        return Time.minutesAsSeconds(value) * 60L;
    }

    protected static long daysAsSeconds(long value) {
        return Time.hoursAsSeconds(value) * 24L;
    }
}

