/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.spi.Injector;
import org.apache.camel.util.NoFactoryAvailableException;

public class FactoryFinder {
    private final String path;
    private final ConcurrentHashMap classMap = new ConcurrentHashMap();

    public FactoryFinder() {
        this("META-INF/services/org/apache/camel/");
    }

    public FactoryFinder(String path) {
        this.path = path;
    }

    public Object newInstance(String key) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        return this.newInstance(key, (String)null);
    }

    public Object newInstance(String key, String propertyPrefix) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Class clazz = this.findClass(key, propertyPrefix);
        return clazz.newInstance();
    }

    public Object newInstance(String key, Injector injector) throws IOException, ClassNotFoundException {
        return this.newInstance(key, injector, null);
    }

    public Object newInstance(String key, Injector injector, String propertyPrefix) throws IOException, ClassNotFoundException {
        Class type = this.findClass(key, propertyPrefix);
        return injector.newInstance(type);
    }

    public Class findClass(String key) throws ClassNotFoundException, IOException {
        return this.findClass(key, null);
    }

    public Class findClass(String key, String propertyPrefix) throws ClassNotFoundException, IOException {
        Class clazz;
        if (propertyPrefix == null) {
            propertyPrefix = "";
        }
        if ((clazz = (Class)this.classMap.get(propertyPrefix + key)) == null) {
            clazz = this.newInstance(this.doFindFactoryProperies(key), propertyPrefix);
            this.classMap.put(propertyPrefix + key, clazz);
        }
        return clazz;
    }

    private Class newInstance(Properties properties, String propertyPrefix) throws ClassNotFoundException, IOException {
        String className = properties.getProperty(propertyPrefix + "class");
        if (className == null) {
            throw new IOException("Expected property is missing: " + propertyPrefix + "class");
        }
        Class<?> clazz = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                clazz = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = FactoryFinder.class.getClassLoader().loadClass(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties doFindFactoryProperies(String key) throws IOException {
        InputStream in;
        String uri = this.path + key;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((in = classLoader.getResourceAsStream(uri)) == null && (in = FactoryFinder.class.getClassLoader().getResourceAsStream(uri)) == null) {
            throw new NoFactoryAvailableException(uri);
        }
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(in);
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
    }
}

