/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.xml;

import java.util.HashSet;
import java.util.Set;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.EndpointFactoryBean;
import org.apache.camel.spring.xml.BeanDefinitionParser;
import org.apache.camel.spring.xml.CamelBeanDefinitionParser;
import org.apache.camel.spring.xml.ScriptDefinitionParser;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelNamespaceHandler
extends NamespaceHandlerSupport {
    protected CamelBeanDefinitionParser routesParser = new CamelBeanDefinitionParser(this);
    protected BeanDefinitionParser endpointParser = new BeanDefinitionParser(EndpointFactoryBean.class);
    protected BeanDefinitionParser beanPostProcessorParser = new BeanDefinitionParser(CamelBeanPostProcessor.class);
    protected Set<String> parserElementNames = new HashSet<String>();

    public void init() {
        this.registerParser("routes", (org.springframework.beans.factory.xml.BeanDefinitionParser)this.routesParser);
        this.registerParser("routeBuilder", (org.springframework.beans.factory.xml.BeanDefinitionParser)this.routesParser);
        this.registerParser("endpoint", (org.springframework.beans.factory.xml.BeanDefinitionParser)this.endpointParser);
        this.registerParser("camelContext", (org.springframework.beans.factory.xml.BeanDefinitionParser)new BeanDefinitionParser(CamelContextFactoryBean.class){

            protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
                super.doParse(element, parserContext, builder);
                String contextId = element.getAttribute("id");
                Element routes = element.getOwnerDocument().createElement("routes");
                NodeList list = element.getChildNodes();
                int size = list.getLength();
                for (int i = 0; i < size; ++i) {
                    Node child = list.item(i);
                    if (!(child instanceof Element)) continue;
                    Element childElement = (Element)child;
                    if (child.getLocalName().equals("beanPostProcessor")) {
                        String beanPostProcessorId = contextId + ":beanPostProcessor";
                        childElement.setAttribute("id", beanPostProcessorId);
                        BeanDefinition definition = CamelNamespaceHandler.this.beanPostProcessorParser.parse(childElement, parserContext);
                        definition.getPropertyValues().addPropertyValue("camelContext", (Object)new RuntimeBeanReference(contextId));
                        continue;
                    }
                    element.removeChild(child);
                    routes.appendChild(child);
                }
                String routeId = contextId + ":routes";
                routes.setAttribute("id", routeId);
                BeanDefinition definition = CamelNamespaceHandler.this.routesParser.parse(routes, parserContext);
                definition.getPropertyValues().addPropertyValue("context", (Object)new RuntimeBeanReference(contextId));
                parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, routeId));
                list = routes.getElementsByTagName("endpoint");
                int size2 = list.getLength();
                for (int i = 0; i < size2; ++i) {
                    Element node = (Element)list.item(i);
                    definition = CamelNamespaceHandler.this.endpointParser.parse(node, parserContext);
                    String id = node.getAttribute("id");
                    if (!ObjectHelper.isNotNullOrBlank(id)) continue;
                    definition.getPropertyValues().addPropertyValue("context", (Object)new RuntimeBeanReference(contextId));
                    parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(definition, id));
                }
            }
        });
        this.registerParser("xpath", (org.springframework.beans.factory.xml.BeanDefinitionParser)new BeanDefinitionParser(XPathBuilder.class){

            protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
                String xpath = DomUtils.getTextValue((Element)element);
                builder.addConstructorArg((Object)xpath);
                super.doParse(element, parserContext, builder);
                builder.addPropertyValue("namespacesFromDom", (Object)element);
            }
        });
        this.registerScriptParser("script", null);
        this.registerScriptParser("groovy", "groovy");
        this.registerScriptParser("ruby", "jruby");
        this.registerScriptParser("javaScript", "js");
        this.registerScriptParser("python", "python");
        this.registerScriptParser("php", "php");
    }

    protected void registerScriptParser(String elementName, String engineName) {
        this.registerParser(elementName, (org.springframework.beans.factory.xml.BeanDefinitionParser)new ScriptDefinitionParser(engineName));
    }

    protected void registerParser(String name, org.springframework.beans.factory.xml.BeanDefinitionParser parser) {
        this.parserElementNames.add(name);
        this.registerBeanDefinitionParser(name, parser);
    }

    public Set<String> getParserElementNames() {
        return this.parserElementNames;
    }
}

