/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.impl.ReflectionInjector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractRefreshableApplicationContext;

public class SpringInjector
extends ReflectionInjector {
    private static final transient Log log = LogFactory.getLog(SpringInjector.class);
    private final AbstractRefreshableApplicationContext applicationContext;
    private int autowireMode = 3;
    private boolean dependencyCheck = false;

    public SpringInjector(AbstractRefreshableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object newInstance(Class type) {
        return this.applicationContext.getBeanFactory().createBean(type, this.autowireMode, this.dependencyCheck);
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public boolean isDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }
}

