/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelTemplate;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.MessageDriven;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spring.util.BeanInfo;
import org.apache.camel.spring.util.DefaultMethodInvocationStrategy;
import org.apache.camel.spring.util.MethodInvocationStrategy;
import org.apache.camel.spring.util.ReflectionUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final transient Log log = LogFactory.getLog(CamelBeanPostProcessor.class);
    private CamelContext camelContext;
    private ApplicationContext applicationContext;
    private MethodInvocationStrategy invocationStrategy = new DefaultMethodInvocationStrategy();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.injectFields(bean);
        this.injectMethods(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public MethodInvocationStrategy getInvocationStrategy() {
        return this.invocationStrategy;
    }

    public void setInvocationStrategy(MethodInvocationStrategy invocationStrategy) {
        this.invocationStrategy = invocationStrategy;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void injectFields(final Object bean) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                EndpointInject annotation = field.getAnnotation(EndpointInject.class);
                if (annotation != null) {
                    ReflectionUtils.setField(field, bean, CamelBeanPostProcessor.this.getEndpointInjectionValue(annotation, field.getType()));
                }
            }
        });
    }

    protected void injectMethods(final Object bean) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                CamelBeanPostProcessor.this.setterInjection(method, bean);
                CamelBeanPostProcessor.this.consumerInjection(method, bean);
            }
        });
    }

    protected void setterInjection(Method method, Object bean) {
        Class<?>[] parameterTypes;
        EndpointInject annoation = method.getAnnotation(EndpointInject.class);
        if (annoation != null && (parameterTypes = method.getParameterTypes()) != null) {
            if (parameterTypes.length != 1) {
                log.warn((Object)("Ignoring badly annotated method for injection due to incorrect number of parameters: " + method));
            } else {
                Object value = this.getEndpointInjectionValue(annoation, parameterTypes[0]);
                ObjectHelper.invokeMethod(method, bean, value);
            }
        }
    }

    protected void consumerInjection(Object bean) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            }
        });
    }

    protected void consumerInjection(Method method, Object bean) {
        MessageDriven annotation = method.getAnnotation(MessageDriven.class);
        if (annotation != null) {
            log.info((Object)("Creating a consumer for: " + annotation));
            Endpoint endpoint = this.getEndpointInjection(annotation.uri(), annotation.name());
            if (endpoint != null) {
                try {
                    Processor processor = this.createConsumerProcessor(bean, method, endpoint);
                    log.info((Object)("Created processor: " + processor));
                    Consumer consumer = endpoint.createConsumer(processor);
                    consumer.start();
                    this.addConsumer(consumer);
                }
                catch (Exception e) {
                    log.warn((Object)e);
                    throw new RuntimeCamelException(e);
                }
            }
        }
    }

    protected Processor createConsumerProcessor(final Object pojo, final Method method, final Endpoint endpoint) {
        final BeanInfo beanInfo = new BeanInfo(pojo.getClass(), this.invocationStrategy);
        return new Processor(){

            public String toString() {
                return "Processor on " + endpoint;
            }

            public void process(Exchange exchange) throws Exception {
                MethodInvocation invocation;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">>>> invoking method for: " + exchange));
                }
                if ((invocation = beanInfo.createInvocation(method, pojo, exchange)) == null) {
                    throw new IllegalStateException("No method invocation could be created");
                }
                try {
                    invocation.proceed();
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new Exception(throwable);
                }
            }
        };
    }

    protected void addConsumer(Consumer consumer) {
        log.debug((Object)("Adding consumer: " + consumer));
    }

    protected Object getEndpointInjectionValue(EndpointInject annotation, Class<?> type) {
        Endpoint endpoint = this.getEndpointInjection(annotation.uri(), annotation.name());
        if (endpoint != null) {
            if (type.isInstance(endpoint)) {
                return endpoint;
            }
            if (type.isAssignableFrom(Producer.class)) {
                try {
                    return endpoint.createProducer();
                }
                catch (Exception e) {
                    throw new RuntimeCamelException(e);
                }
            }
            if (type.isAssignableFrom(CamelTemplate.class)) {
                return new CamelTemplate(this.getCamelContext(), endpoint);
            }
        }
        return null;
    }

    protected Endpoint getEndpointInjection(String uri, String name) {
        Endpoint endpoint = null;
        if (ObjectHelper.isNotNullOrBlank(uri)) {
            endpoint = this.camelContext.getEndpoint(uri);
        } else if (ObjectHelper.isNotNullOrBlank(name)) {
            endpoint = (Endpoint)this.applicationContext.getBean(name);
            if (endpoint == null) {
                throw new NoSuchBeanDefinitionException(name);
            }
        } else {
            log.warn((Object)"No uri or name specified on @EndpointInject annotation!");
        }
        return endpoint;
    }
}

