/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.ServiceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastProcessor
extends ServiceSupport
implements Processor {
    private Collection<Producer> producers;

    public static <E extends Exchange> Collection<Producer> toProducers(Collection<Endpoint> endpoints) throws Exception {
        ArrayList<Producer> answer = new ArrayList<Producer>();
        for (Endpoint endpoint : endpoints) {
            answer.add(endpoint.createProducer());
        }
        return answer;
    }

    public MulticastProcessor(Collection<Endpoint> endpoints) throws Exception {
        this.producers = MulticastProcessor.toProducers(endpoints);
    }

    public String toString() {
        return "Multicast" + this.getEndpoints();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        for (Producer producer : this.producers) {
            Exchange copy = this.copyExchangeStrategy(producer, exchange);
            producer.process(copy);
        }
    }

    @Override
    protected void doStop() throws Exception {
        for (Producer producer : this.producers) {
            producer.stop();
        }
    }

    @Override
    protected void doStart() throws Exception {
        for (Producer producer : this.producers) {
            producer.start();
        }
    }

    public Collection<Producer> getProducers() {
        return this.producers;
    }

    public Collection<Endpoint> getEndpoints() {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        for (Producer producer : this.producers) {
            answer.add(producer.getEndpoint());
        }
        return answer;
    }

    protected Exchange copyExchangeStrategy(Producer producer, Exchange exchange) {
        return producer.createExchange(exchange);
    }
}

