/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

public class DelegateProcessor
extends ServiceSupport
implements Processor {
    protected Processor next;

    public DelegateProcessor() {
    }

    public DelegateProcessor(Processor next) {
        this.next = next;
    }

    public void process(Exchange exchange) throws Exception {
        this.processNext(exchange);
    }

    protected void processNext(Exchange exchange) throws Exception {
        if (this.next != null) {
            this.next.process(exchange);
        }
    }

    public String toString() {
        return "delegate(" + this.next + ")";
    }

    public Processor getNext() {
        return this.next;
    }

    public void setNext(Processor next) {
        this.next = next;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.next);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.next);
    }
}

