/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.MessageSupport;
import org.apache.camel.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchange
implements Exchange {
    private static final UuidGenerator defaultIdGenerator = new UuidGenerator();
    protected final CamelContext context;
    private Map<String, Object> headers;
    private Message in;
    private Message out;
    private Message fault;
    private Throwable exception;
    private String exchangeId = defaultIdGenerator.generateId();

    public DefaultExchange(CamelContext context) {
        this.context = context;
    }

    public String toString() {
        return "Exchange[" + this.in + "]";
    }

    @Override
    public Exchange copy() {
        Exchange exchange = this.newInstance();
        exchange.copyFrom(this);
        return exchange;
    }

    @Override
    public void copyFrom(Exchange exchange) {
        if (exchange == this) {
            return;
        }
        this.setHeaders(DefaultExchange.safeCopy(exchange.getProperties()));
        this.setIn(DefaultExchange.safeCopy(exchange.getIn()));
        this.setOut(DefaultExchange.safeCopy(exchange.getOut()));
        this.setFault(DefaultExchange.safeCopy(exchange.getFault()));
        this.setException(exchange.getException());
    }

    private static Map<String, Object> safeCopy(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return new HashMap<String, Object>(properties);
    }

    private static Message safeCopy(Message message) {
        if (message == null) {
            return null;
        }
        return message.copy();
    }

    public Exchange newInstance() {
        return new DefaultExchange(this.context);
    }

    @Override
    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public Object getProperty(String name) {
        if (this.headers != null) {
            return this.headers.get(name);
        }
        return null;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        return this.getContext().getTypeConverter().convertTo(type, value);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    @Override
    public Message getIn() {
        if (this.in == null) {
            this.in = this.createInMessage();
            this.configureMessage(this.in);
        }
        return this.in;
    }

    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    @Override
    public Message getOut() {
        return this.getOut(true);
    }

    @Override
    public Message getOut(boolean lazyCreate) {
        if (this.out == null && lazyCreate) {
            this.out = this.createOutMessage();
            this.configureMessage(this.out);
        }
        return this.out;
    }

    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void setException(Throwable exception) {
        this.exception = exception;
    }

    @Override
    public Message getFault() {
        return this.fault;
    }

    public void setFault(Message fault) {
        this.fault = fault;
        this.configureMessage(fault);
    }

    @Override
    public String getExchangeId() {
        return this.exchangeId;
    }

    @Override
    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    protected Message createInMessage() {
        return new DefaultMessage();
    }

    protected Message createOutMessage() {
        return new DefaultMessage();
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange(this);
        }
    }
}

