/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rmi;

import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.apache.camel.Exchange;
import org.apache.camel.component.pojo.PojoEndpoint;
import org.apache.camel.component.pojo.PojoExchange;
import org.apache.camel.component.rmi.RmiEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class RmiProducer
extends DefaultProducer {
    private final RmiEndpoint endpoint;
    private Remote remote;

    public RmiProducer(RmiEndpoint endpoint) throws AccessException, RemoteException, NotBoundException {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws AccessException, RemoteException, NotBoundException {
        PojoExchange pojoExchange = (PojoExchange)this.endpoint.toExchangeType(exchange);
        PojoEndpoint.invoke(this.getRemote(), pojoExchange);
        exchange.copyFrom(pojoExchange);
    }

    public Remote getRemote() throws AccessException, RemoteException, NotBoundException {
        if (this.remote == null) {
            Registry registry = this.endpoint.getRegistry();
            this.remote = registry.lookup(this.endpoint.getName());
        }
        return this.remote;
    }
}

