/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pojo;

import java.lang.reflect.InvocationTargetException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pojo.NoPojoAvailableException;
import org.apache.camel.component.pojo.PojoExchange;
import org.apache.camel.component.pojo.PojoInvocation;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoEndpoint
extends DefaultEndpoint<PojoExchange> {
    private Object pojo;

    public PojoEndpoint(String uri, Component component, Object pojo) {
        super(uri, component);
        this.pojo = pojo;
    }

    @Override
    public Producer<PojoExchange> createProducer() throws Exception {
        final Object pojo = this.getPojo();
        if (pojo == null) {
            throw new NoPojoAvailableException(this);
        }
        return new DefaultProducer(this){

            public void process(Exchange exchange) {
                PojoExchange pojoExchange = (PojoExchange)PojoEndpoint.this.toExchangeType(exchange);
                PojoEndpoint.invoke(pojo, pojoExchange);
                exchange.copyFrom(pojoExchange);
            }
        };
    }

    @Override
    public Consumer<PojoExchange> createConsumer(Processor processor) throws Exception {
        throw new Exception("You cannot consume from pojo endpoints.");
    }

    public static void invoke(Object pojo, PojoExchange exchange) {
        PojoInvocation invocation = exchange.getInvocation();
        try {
            Object response = invocation.getMethod().invoke(pojo, invocation.getArgs());
            exchange.getOut().setBody(response);
        }
        catch (InvocationTargetException e) {
            exchange.setException(e.getCause());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PojoExchange createExchange() {
        return new PojoExchange(this.getContext());
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public Object getPojo() {
        return this.pojo;
    }

    public void setPojo(Object pojo) {
        this.pojo = pojo;
    }
}

