/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mock.AssertionClause;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockEndpoint
extends DefaultEndpoint<Exchange> {
    private static final transient Log log = LogFactory.getLog(MockEndpoint.class);
    private int expectedCount = -1;
    private Map<Integer, Processor> processors = new HashMap<Integer, Processor>();
    private List<Exchange> receivedExchanges = new ArrayList<Exchange>();
    private List<Throwable> failures = new ArrayList<Throwable>();
    private List<Runnable> tests = new ArrayList<Runnable>();
    private CountDownLatch latch;
    private long sleepForEmptyTest = 0L;
    private int expectedMinimumCount = -1;

    public static void assertWait(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        long start = System.currentTimeMillis();
        long left = unit.toMillis(timeout);
        long end = start + left;
        for (MockEndpoint endpoint : endpoints) {
            if (!endpoint.await(left, TimeUnit.MILLISECONDS)) {
                throw new AssertionError((Object)("Timeout waiting for endpoints to receive enough messages. " + endpoint.getEndpointUri() + " timed out."));
            }
            left = end - System.currentTimeMillis();
            if (left > 0L) continue;
            left = 0L;
        }
    }

    public static void assertIsSatisfied(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        MockEndpoint.assertWait(timeout, unit, endpoints);
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(MockEndpoint ... endpoints) throws InterruptedException {
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void expectsMessageCount(int count, MockEndpoint ... endpoints) throws InterruptedException {
        for (MockEndpoint endpoint : endpoints) {
            MockEndpoint.expectsMessageCount(count, new MockEndpoint[0]);
        }
    }

    public MockEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @Override
    public Exchange createExchange() {
        return new DefaultExchange(this.getContext());
    }

    @Override
    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume from this endpoint");
    }

    @Override
    public Producer<Exchange> createProducer() throws Exception {
        return new DefaultProducer<Exchange>((Endpoint)this){

            @Override
            public void process(Exchange exchange) {
                MockEndpoint.this.onExchange(exchange);
            }
        };
    }

    public void assertIsSatisfied() throws InterruptedException {
        this.assertIsSatisfied(this.sleepForEmptyTest);
    }

    public void assertIsSatisfied(long timeoutForEmptyEndpoints) throws InterruptedException {
        int receivedCounter;
        if (this.latch != null) {
            this.latch.await(10L, TimeUnit.SECONDS);
        } else if (this.expectedCount == 0 && timeoutForEmptyEndpoints > 0L) {
            Thread.sleep(timeoutForEmptyEndpoints);
        }
        if (this.expectedCount >= 0) {
            receivedCounter = this.getReceivedCounter();
            this.assertEquals("Received message count", this.expectedCount, receivedCounter);
        }
        if (this.expectedMinimumCount >= 0) {
            receivedCounter = this.getReceivedCounter();
            this.assertTrue("Received message count " + receivedCounter + ", expected at least " + this.expectedCount, this.expectedCount <= receivedCounter);
        }
        for (Runnable test : this.tests) {
            test.run();
        }
        for (Throwable failure : this.failures) {
            if (failure == null) continue;
            log.error((Object)("Caught on " + this.getEndpointUri() + " Exception: " + failure), failure);
            this.fail("Failed due to caught exception: " + failure);
        }
    }

    public void expectedMessageCount(int expectedCount) {
        this.expectedCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(expectedCount);
    }

    public void expectedMinimumMessageCount(int expectedCount) {
        this.expectedMinimumCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(this.expectedMinimumCount);
    }

    public void expectedBodiesReceived(final List bodies) {
        this.expectedMessageCount(bodies.size());
        this.expects(new Runnable(){

            public void run() {
                int counter = 0;
                for (Object expectedBody : bodies) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchanges().get(counter++);
                    MockEndpoint.this.assertTrue("No exchange received for counter: " + counter, exchange != null);
                    Message in = exchange.getIn();
                    Object actualBody = expectedBody != null ? in.getBody(expectedBody.getClass()) : in.getBody();
                    MockEndpoint.this.assertEquals("Body of message: " + counter, expectedBody, actualBody);
                    log.debug((Object)(MockEndpoint.this.getEndpointUri() + " >>>> message: " + counter + " with body: " + actualBody));
                }
            }
        });
    }

    public void expectedBodiesReceived(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        for (Object body : bodies) {
            bodyList.add(body);
        }
        this.expectedBodiesReceived(bodyList);
    }

    public void expects(Runnable runnable) {
        this.tests.add(runnable);
    }

    public AssertionClause message(final int messageIndex) {
        AssertionClause clause = new AssertionClause(){

            public void run() {
                this.applyAssertionOn(MockEndpoint.this, messageIndex, MockEndpoint.this.assertExchangeReceived(messageIndex));
            }
        };
        this.expects(clause);
        return clause;
    }

    public AssertionClause allMessages() {
        AssertionClause clause = new AssertionClause(){

            public void run() {
                List<Exchange> list = MockEndpoint.this.getReceivedExchanges();
                int index = 0;
                for (Exchange exchange : list) {
                    this.applyAssertionOn(MockEndpoint.this, index++, exchange);
                }
            }
        };
        this.expects(clause);
        return clause;
    }

    public Exchange assertExchangeReceived(int index) {
        int count = this.getReceivedCounter();
        this.assertTrue("Not enough messages received. Was: " + count, count > index);
        return this.getReceivedExchanges().get(index);
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    public int getReceivedCounter() {
        return this.getReceivedExchanges().size();
    }

    public List<Exchange> getReceivedExchanges() {
        return this.receivedExchanges;
    }

    public int getExpectedCount() {
        return this.expectedCount;
    }

    public long getSleepForEmptyTest() {
        return this.sleepForEmptyTest;
    }

    public void setSleepForEmptyTest(long sleepForEmptyTest) {
        this.sleepForEmptyTest = sleepForEmptyTest;
    }

    protected synchronized void onExchange(Exchange exchange) {
        try {
            log.debug((Object)(this.getEndpointUri() + " >>>> " + exchange));
            this.receivedExchanges.add(exchange);
            Processor processor = this.processors.get(this.getReceivedCounter());
            if (processor != null) {
                processor.process(exchange);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
        catch (Exception e) {
            this.failures.add(e);
        }
    }

    protected void assertEquals(String message, Object expectedValue, Object actualValue) {
        if (!ObjectHelper.equals(expectedValue, actualValue)) {
            this.fail(message + ". Expected: <" + expectedValue + "> but was: <" + actualValue + ">");
        }
    }

    protected void assertTrue(String message, boolean predicate) {
        if (!predicate) {
            this.fail(message);
        }
    }

    protected void fail(Object message) {
        throw new AssertionError((Object)(this.getEndpointUri() + " " + message));
    }

    public int getExpectedMinimumCount() {
        return this.expectedMinimumCount;
    }

    public void await() throws InterruptedException {
        if (this.latch != null) {
            this.latch.await();
        }
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.latch != null) {
            return this.latch.await(timeout, unit);
        }
        return true;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

