/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import org.apache.camel.Exchange;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

public class MinaProducer
extends DefaultProducer {
    private static final transient Log log = LogFactory.getLog(MinaProducer.class);
    private IoSession session;
    private MinaEndpoint endpoint;

    public MinaProducer(MinaEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) {
        if (this.session == null) {
            throw new IllegalStateException("Not started yet!");
        }
        Object body = exchange.getIn().getBody();
        if (body == null) {
            log.warn((Object)("No payload for exchange: " + exchange));
        } else {
            this.session.write(body);
        }
    }

    protected void doStart() throws Exception {
        SocketAddress address = this.endpoint.getAddress();
        IoConnector connector = this.endpoint.getConnector();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating connector to address: " + address + " using connector: " + connector));
        }
        IoHandlerAdapter ioHandler = new IoHandlerAdapter(){

            public void messageReceived(IoSession ioSession, Object object) throws Exception {
                super.messageReceived(ioSession, object);
            }
        };
        ConnectFuture future = connector.connect(address, (IoHandler)ioHandler, this.endpoint.getConfig());
        future.join();
        this.session = future.getSession();
    }

    protected void doStop() throws Exception {
        if (this.session != null) {
            this.session.close().join(2000L);
        }
    }
}

