/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointMessageListener<E extends Exchange>
implements MessageListener {
    private static final transient Log log = LogFactory.getLog(EndpointMessageListener.class);
    private Endpoint<E> endpoint;
    private Processor processor;
    private JmsBinding binding;

    public EndpointMessageListener(Endpoint<E> endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public void onMessage(Message message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.endpoint + " receiving JMS message: " + message));
            }
            JmsExchange exchange = this.createExchange(message);
            this.processor.process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public JmsExchange createExchange(Message message) {
        return new JmsExchange(this.endpoint.getContext(), this.getBinding(), message);
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JmsBinding();
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }
}

