/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpExchange;

public class CamelServlet
extends HttpServlet {
    private ConcurrentHashMap<String, HttpConsumer> consumers = new ConcurrentHashMap();

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HttpConsumer consumer = this.resolve(request);
            if (consumer == null) {
                response.sendError(404);
                return;
            }
            HttpExchange exchange = new HttpExchange(consumer.getEndpoint(), request, response);
            consumer.getProcessor().process(exchange);
            consumer.getBinding().writeResponse(exchange);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected HttpConsumer resolve(HttpServletRequest request) {
        String path = request.getPathInfo();
        return this.consumers.get(path);
    }

    public void connect(HttpConsumer consumer) {
        this.consumers.put(consumer.getPath(), consumer);
    }

    public void disconnect(HttpConsumer consumer) {
        this.consumers.remove(consumer.getPath());
    }
}

