/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.file.FileComponent;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.FileProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEndpoint
extends ScheduledPollEndpoint<FileExchange> {
    private File file;
    private boolean autoCreate = true;

    protected FileEndpoint(File file, String endpointUri, FileComponent component) {
        super(endpointUri, component);
        this.file = file;
    }

    @Override
    public Producer<FileExchange> createProducer() throws Exception {
        FileProducer result = new FileProducer(this);
        return result;
    }

    @Override
    public Consumer<FileExchange> createConsumer(Processor file) throws Exception {
        FileConsumer result = new FileConsumer(this, file);
        this.configureConsumer(result);
        return result;
    }

    public FileExchange createExchange(File file) {
        return new FileExchange(this.getContext(), file);
    }

    @Override
    public FileExchange createExchange() {
        return this.createExchange(this.getFile());
    }

    public File getFile() {
        if (this.autoCreate && !this.file.exists()) {
            this.file.mkdirs();
        }
        return this.file;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }
}

