/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConsumer
extends ScheduledPollConsumer<FileExchange> {
    private static final transient Log log = LogFactory.getLog(FileConsumer.class);
    private final FileEndpoint endpoint;
    private boolean recursive = true;
    private boolean attemptFileLock = false;
    private String regexPattern = "";
    private long lastPollTime = 0L;

    public FileConsumer(FileEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void poll() throws Exception {
        this.pollFileOrDirectory(this.endpoint.getFile(), this.isRecursive());
        this.lastPollTime = System.currentTimeMillis();
    }

    protected void pollFileOrDirectory(File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            log.debug((Object)("Polling directory " + fileOrDirectory));
            File[] files = fileOrDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.pollFileOrDirectory(files[i], this.isRecursive());
            }
        } else {
            log.debug((Object)("Skipping directory " + fileOrDirectory));
        }
    }

    protected void pollFile(File file) {
        if (file.exists() && file.lastModified() > this.lastPollTime && this.isValidFile(file)) {
            this.processFile(file);
        }
    }

    protected void processFile(File file) {
        try {
            this.getProcessor().process(this.endpoint.createExchange(file));
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isValidFile(File file) {
        boolean result = false;
        if (file != null && file.exists() && this.isMatched(file)) {
            if (this.isAttemptFileLock()) {
                FileChannel fc = null;
                try {
                    fc = new RandomAccessFile(file, "rw").getChannel();
                    fc.lock();
                    result = true;
                }
                catch (Throwable e) {
                    log.debug((Object)("Failed to get the lock on file: " + file), e);
                }
                finally {
                    if (fc != null) {
                        try {
                            fc.close();
                        }
                        catch (IOException e) {}
                    }
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    protected boolean isMatched(File file) {
        boolean result = true;
        if (this.regexPattern != null && this.regexPattern.length() > 0) {
            result = file.getName().matches(this.getRegexPattern());
        }
        return result;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isAttemptFileLock() {
        return this.attemptFileLock;
    }

    public void setAttemptFileLock(boolean attemptFileLock) {
        this.attemptFileLock = attemptFileLock;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }
}

