/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalTransportFactory;

public class CxfProducer
extends DefaultProducer {
    private CxfEndpoint endpoint;
    private final LocalTransportFactory transportFactory;
    private Destination destination;
    private Conduit conduit;
    private ResultFuture future = new ResultFuture();

    public CxfProducer(CxfEndpoint endpoint, LocalTransportFactory transportFactory) {
        super(endpoint);
        this.endpoint = endpoint;
        this.transportFactory = transportFactory;
    }

    public void process(Exchange exchange) {
        CxfExchange cxfExchange = (CxfExchange)this.endpoint.toExchangeType(exchange);
        this.process(cxfExchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(CxfExchange exchange) {
        try {
            CxfBinding binding = this.endpoint.getBinding();
            MessageImpl m = binding.createCxfMessage(exchange);
            ExchangeImpl e = new ExchangeImpl();
            e.setInMessage((Message)m);
            m.put((Object)LocalConduit.DIRECT_DISPATCH, (Object)Boolean.TRUE);
            m.setDestination(this.destination);
            Conduit conduit = this.conduit;
            synchronized (conduit) {
                this.conduit.prepare((Message)m);
                if (this.endpoint.isInOut()) {
                    Message response = this.future.getResponse();
                    response = e.getOutMessage();
                    binding.storeCxfResponse(exchange, response);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeCamelException(e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        EndpointInfo endpointInfo = this.endpoint.getEndpointInfo();
        this.destination = this.transportFactory.getDestination(endpointInfo);
        this.conduit = this.transportFactory.getConduit(endpointInfo);
        this.conduit.setMessageObserver((MessageObserver)this.future);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.conduit != null) {
            this.conduit.close();
        }
    }

    protected class ResultFuture
    implements MessageObserver {
        Message response;
        CountDownLatch latch = new CountDownLatch(1);

        protected ResultFuture() {
        }

        public Message getResponse() {
            while (this.response == null) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onMessage(Message message) {
            try {
                message.remove((Object)LocalConduit.DIRECT_DISPATCH);
                this.response = message;
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

