/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfInvokeEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;

public class CxfInvokeProducer
extends DefaultProducer {
    private CxfInvokeEndpoint endpoint;
    private Client client;

    public CxfInvokeProducer(CxfInvokeEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) {
        CxfExchange cxfExchange = (CxfExchange)this.endpoint.toExchangeType(exchange);
        this.process(cxfExchange);
        exchange.copyFrom(cxfExchange);
    }

    public void process(CxfExchange exchange) {
        List params = exchange.getIn().getBody(List.class);
        Object[] response = null;
        try {
            response = this.client.invoke(this.endpoint.getProperty("method"), params.toArray());
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
        CxfBinding binding = this.endpoint.getBinding();
        binding.storeCxfResponse(exchange, response);
    }

    protected void doStart() throws Exception {
        if (this.client == null) {
            ClientFactoryBean cfBean = new ClientFactoryBean();
            cfBean.setAddress(this.getEndpoint().getEndpointUri());
            cfBean.setBus(this.endpoint.getBus());
            cfBean.setServiceClass(Class.forName(this.endpoint.getProperty("sei")));
            this.client = cfBean.create();
        }
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.getConduit().close();
            this.client = null;
        }
        super.doStop();
    }
}

