/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.builder.xml.DefaultNamespaceContext;
import org.apache.camel.builder.xml.InvalidXPathExpression;
import org.apache.camel.builder.xml.MessageVariableResolver;
import org.apache.camel.converter.ObjectConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathBuilder<E extends Exchange>
implements Expression<E>,
Predicate<E> {
    private final String text;
    private XPathFactory xpathFactory;
    private Class documentType = Document.class;
    private QName resultType = null;
    private String objectModelUri = null;
    private DefaultNamespaceContext namespaceContext;
    private XPathFunctionResolver functionResolver;
    private XPathExpression expression;
    private MessageVariableResolver variableResolver = new MessageVariableResolver();

    public static XPathBuilder xpath(String text) {
        return new XPathBuilder(text);
    }

    public XPathBuilder(String text) {
        this.text = text;
    }

    public String toString() {
        return "XPath: " + this.text;
    }

    @Override
    public boolean matches(E exchange) {
        Object booleanResult = this.evaluateAs(exchange, XPathConstants.BOOLEAN);
        return ObjectConverter.toBoolean(booleanResult);
    }

    @Override
    public void assertMatches(String text, E exchange) throws AssertionError {
        Object booleanResult = this.evaluateAs(exchange, XPathConstants.BOOLEAN);
        if (!ObjectConverter.toBoolean(booleanResult).booleanValue()) {
            throw new AssertionError((Object)(this + " failed on " + exchange + " as returned <" + booleanResult + ">"));
        }
    }

    @Override
    public Object evaluate(E exchange) {
        return this.evaluateAs(exchange, this.resultType);
    }

    public XPathBuilder<E> booleanResult() {
        this.resultType = XPathConstants.BOOLEAN;
        return this;
    }

    public XPathBuilder<E> nodeResult() {
        this.resultType = XPathConstants.NODE;
        return this;
    }

    public XPathBuilder<E> nodeSetResult() {
        this.resultType = XPathConstants.NODESET;
        return this;
    }

    public XPathBuilder<E> numberResult() {
        this.resultType = XPathConstants.NUMBER;
        return this;
    }

    public XPathBuilder<E> stringResult() {
        this.resultType = XPathConstants.STRING;
        return this;
    }

    public XPathBuilder<E> objectModel(String uri) {
        this.objectModelUri = uri;
        return this;
    }

    public XPathBuilder<E> functionResolver(XPathFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
        return this;
    }

    public XPathBuilder<E> namespace(String prefix, String uri) {
        this.getNamespaceContext().add(prefix, uri);
        return this;
    }

    public XPathBuilder<E> variable(String name, Object value) {
        this.variableResolver.addVariable(name, value);
        return this;
    }

    public XPathFactory getXPathFactory() throws XPathFactoryConfigurationException {
        if (this.xpathFactory == null) {
            if (this.objectModelUri != null) {
                this.xpathFactory = XPathFactory.newInstance(this.objectModelUri);
            }
            this.xpathFactory = XPathFactory.newInstance();
        }
        return this.xpathFactory;
    }

    public void setXPathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public Class getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Class documentType) {
        this.documentType = documentType;
    }

    public String getText() {
        return this.text;
    }

    public QName getResultType() {
        return this.resultType;
    }

    public DefaultNamespaceContext getNamespaceContext() {
        if (this.namespaceContext == null) {
            try {
                this.namespaceContext = new DefaultNamespaceContext(this.getXPathFactory());
            }
            catch (XPathFactoryConfigurationException e) {
                throw new RuntimeExpressionException(e);
            }
        }
        return this.namespaceContext;
    }

    public void setNamespaceContext(DefaultNamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public XPathFunctionResolver getFunctionResolver() {
        return this.functionResolver;
    }

    public void setFunctionResolver(XPathFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    public XPathExpression getExpression() throws XPathFactoryConfigurationException, XPathExpressionException {
        if (this.expression == null) {
            this.expression = this.createXPathExpression();
        }
        return this.expression;
    }

    public void setNamespacesFromDom(Element node) {
        this.getNamespaceContext().setNamespacesFromDom(node);
    }

    protected synchronized Object evaluateAs(E exchange, QName resultType) {
        this.variableResolver.setExchange((Exchange)exchange);
        try {
            Object document = this.getDocument(exchange);
            if (resultType != null) {
                if (document instanceof InputSource) {
                    InputSource inputSource = (InputSource)document;
                    return this.getExpression().evaluate(inputSource, resultType);
                }
                return this.getExpression().evaluate(document, resultType);
            }
            if (document instanceof InputSource) {
                InputSource inputSource = (InputSource)document;
                return this.getExpression().evaluate(inputSource);
            }
            return this.getExpression().evaluate(document);
        }
        catch (XPathExpressionException e) {
            throw new InvalidXPathExpression(this.getText(), e);
        }
        catch (XPathFactoryConfigurationException e) {
            throw new InvalidXPathExpression(this.getText(), e);
        }
    }

    protected XPathExpression createXPathExpression() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xPath = this.getXPathFactory().newXPath();
        this.xpathFactory = null;
        xPath.setNamespaceContext(this.getNamespaceContext());
        xPath.setXPathVariableResolver(this.variableResolver);
        if (this.functionResolver != null) {
            xPath.setXPathFunctionResolver(this.functionResolver);
        }
        return xPath.compile(this.text);
    }

    protected Object getDocument(E exchange) {
        Message in = exchange.getIn();
        Class type = this.getDocumentType();
        Object answer = null;
        if (type != null) {
            answer = in.getBody(type);
        }
        if (answer == null) {
            answer = in.getBody();
        }
        if (answer instanceof String) {
            answer = new InputSource(new StringReader(answer.toString()));
        }
        return answer;
    }
}

