/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.builder.FromBuilder;
import org.apache.camel.processor.Resequencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResequencerBuilder
extends FromBuilder {
    private final List<Expression<Exchange>> expressions;
    private long batchTimeout = 1000L;
    private int batchSize = 100;

    public ResequencerBuilder(FromBuilder builder, List<Expression<Exchange>> expressions) {
        super(builder);
        this.expressions = expressions;
    }

    @Override
    public Route createRoute() throws Exception {
        final Processor processor = super.createProcessor();
        final Resequencer resequencer = new Resequencer(this.getFrom(), processor, this.expressions);
        return new Route<Exchange>(this.getFrom()){

            @Override
            protected void addServices(List<Service> list) throws Exception {
                list.add(resequencer);
            }

            public String toString() {
                return "ResequencerRoute[" + this.getEndpoint() + " -> " + processor + "]";
            }
        };
    }

    public ResequencerBuilder batchSize(int batchSize) {
        this.setBatchSize(batchSize);
        return this;
    }

    public ResequencerBuilder batchTimeout(int batchTimeout) {
        this.setBatchTimeout(batchTimeout);
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }
}

