/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.Fluent;
import org.apache.camel.builder.FluentArg;
import org.apache.camel.builder.FromBuilder;
import org.apache.camel.builder.ProcessorFactory;
import org.apache.camel.processor.DelegateProcessor;

public class InterceptorBuilder
implements ProcessorFactory {
    private final List<DelegateProcessor> intercepts = new ArrayList<DelegateProcessor>();
    private final FromBuilder parent;
    private FromBuilder target;

    public InterceptorBuilder(FromBuilder parent) {
        this.parent = parent;
    }

    @Fluent(value="interceptor")
    public InterceptorBuilder add(@FluentArg(value="ref") DelegateProcessor interceptor) {
        this.intercepts.add(interceptor);
        return this;
    }

    @Fluent(callOnElementEnd=true)
    public FromBuilder target() {
        this.target = new FromBuilder(this.parent);
        return this.target;
    }

    public Processor createProcessor() throws Exception {
        if (this.target == null) {
            throw new RuntimeCamelException("target provided.");
        }
        DelegateProcessor first = null;
        DelegateProcessor last = null;
        for (DelegateProcessor p : this.intercepts) {
            if (first == null) {
                first = p;
            }
            if (last != null) {
                last.setNext(p);
            }
            last = p;
        }
        Processor p = this.target.createProcessor();
        if (last != null) {
            last.setNext(p);
        }
        return first == null ? p : first;
    }
}

