/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.FromBuilder;
import org.apache.camel.builder.ProcessorFactory;
import org.apache.camel.processor.idempotent.IdempotentConsumer;
import org.apache.camel.processor.idempotent.MessageIdRepository;

public class IdempotentConsumerBuilder
extends FromBuilder
implements ProcessorFactory {
    private final Expression messageIdExpression;
    private final MessageIdRepository messageIdRegistry;

    public IdempotentConsumerBuilder(FromBuilder fromBuilder, Expression messageIdExpression, MessageIdRepository messageIdRegistry) {
        super(fromBuilder);
        this.messageIdRegistry = messageIdRegistry;
        this.messageIdExpression = messageIdExpression;
    }

    public MessageIdRepository getMessageIdRegistry() {
        return this.messageIdRegistry;
    }

    protected Processor wrapInErrorHandler(Processor processor) throws Exception {
        return processor;
    }

    protected Processor wrapProcessor(Processor processor) {
        return new IdempotentConsumer(this.messageIdExpression, this.messageIdRegistry, processor);
    }
}

