/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.Fluent;
import org.apache.camel.builder.FluentArg;
import org.apache.camel.builder.FromBuilder;
import org.apache.camel.builder.WhenBuilder;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceBuilder
extends FromBuilder {
    private final FromBuilder parent;
    private List<WhenBuilder> predicateBuilders = new ArrayList<WhenBuilder>();
    private FromBuilder otherwise;

    public ChoiceBuilder(FromBuilder parent) {
        super(parent);
        this.parent = parent;
    }

    @Fluent(nestedActions=true)
    public WhenBuilder when(@FluentArg(value="predicate", element=true) Predicate predicate) {
        WhenBuilder answer = new WhenBuilder(this, predicate);
        this.predicateBuilders.add(answer);
        return answer;
    }

    @Fluent(nestedActions=true)
    public FromBuilder otherwise() {
        this.otherwise = new FromBuilder(this.parent);
        return this.otherwise;
    }

    public List<WhenBuilder> getPredicateBuilders() {
        return this.predicateBuilders;
    }

    public FromBuilder getOtherwise() {
        return this.otherwise;
    }

    @Override
    public Processor createProcessor() throws Exception {
        ArrayList<FilterProcessor> filters = new ArrayList<FilterProcessor>();
        for (WhenBuilder predicateBuilder : this.predicateBuilders) {
            filters.add(predicateBuilder.createProcessor());
        }
        Processor otherwiseProcessor = null;
        if (this.otherwise != null) {
            otherwiseProcessor = this.otherwise.createProcessor();
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }
}

