/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.FluentArg;
import org.apache.camel.builder.ValueBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder {
    public static <E extends Exchange> ValueBuilder<E> constant(Object value) {
        Expression expression = ExpressionBuilder.constantExpression(value);
        return new ValueBuilder(expression);
    }

    public static <E extends Exchange> ValueBuilder<E> header(@FluentArg(value="name") String name) {
        Expression expression = ExpressionBuilder.headerExpression(name);
        return new ValueBuilder(expression);
    }

    public static <E extends Exchange> ValueBuilder<E> body() {
        Expression expression = ExpressionBuilder.bodyExpression();
        return new ValueBuilder(expression);
    }

    public static <E extends Exchange, T> ValueBuilder<E> bodyAs(Class<T> type) {
        Expression expression = ExpressionBuilder.bodyExpression(type);
        return new ValueBuilder(expression);
    }

    public static <E extends Exchange> ValueBuilder<E> outBody() {
        Expression expression = ExpressionBuilder.bodyExpression();
        return new ValueBuilder(expression);
    }

    public static <E extends Exchange, T> ValueBuilder<E> outBody(Class<T> type) {
        Expression expression = ExpressionBuilder.bodyExpression(type);
        return new ValueBuilder(expression);
    }

    public static <E extends Exchange> ValueBuilder<E> systemProperty(String name) {
        return Builder.systemProperty(name, null);
    }

    public static <E extends Exchange> ValueBuilder<E> systemProperty(String name, String defaultValue) {
        return new ValueBuilder(ExpressionBuilder.systemProperty(name, defaultValue));
    }
}

