/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.processor;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.bam.model.ProcessDefinition;
import org.apache.camel.bam.processor.BamProcessorSupport;
import org.apache.camel.bam.rules.ActivityRules;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaBamProcessorSupport<T>
extends BamProcessorSupport<T> {
    private ActivityRules activityRules;
    private JpaTemplate template;
    private String findByKeyQuery;
    private String keyPropertyName = "correlationKey";

    public JpaBamProcessorSupport(TransactionTemplate transactionTemplate, JpaTemplate template, Expression<Exchange> correlationKeyExpression, ActivityRules activityRules, Class<T> entitytype) {
        super(transactionTemplate, correlationKeyExpression, entitytype);
        this.activityRules = activityRules;
        this.template = template;
    }

    public JpaBamProcessorSupport(TransactionTemplate transactionTemplate, JpaTemplate template, Expression<Exchange> correlationKeyExpression, ActivityRules activityRules) {
        super(transactionTemplate, correlationKeyExpression);
        this.activityRules = activityRules;
        this.template = template;
    }

    public String getFindByKeyQuery() {
        if (this.findByKeyQuery == null) {
            this.findByKeyQuery = this.createFindByKeyQuery();
        }
        return this.findByKeyQuery;
    }

    public void setFindByKeyQuery(String findByKeyQuery) {
        this.findByKeyQuery = findByKeyQuery;
    }

    public ActivityRules getActivityRules() {
        return this.activityRules;
    }

    public void setActivityRules(ActivityRules activityRules) {
        this.activityRules = activityRules;
    }

    public String getKeyPropertyName() {
        return this.keyPropertyName;
    }

    public void setKeyPropertyName(String keyPropertyName) {
        this.keyPropertyName = keyPropertyName;
    }

    public JpaTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JpaTemplate template) {
        this.template = template;
    }

    @Override
    protected T loadEntity(Exchange exchange, Object key) {
        List list = this.template.find(this.getFindByKeyQuery(), new Object[]{key});
        T entity = null;
        if (!list.isEmpty()) {
            entity = (T)list.get(0);
        }
        if (entity == null) {
            entity = this.createEntity(exchange, key);
            this.setKeyProperty(entity, key);
            ProcessDefinition definition = ProcessDefinition.getRefreshedProcessDefinition(this.template, this.getActivityRules().getProcessRules().getProcessDefinition());
            this.setProcessDefinitionProperty(entity, definition);
            this.template.persist(entity);
        }
        return entity;
    }

    protected void setKeyProperty(T entity, Object key) {
        IntrospectionSupport.setProperty(entity, this.getKeyPropertyName(), key);
    }

    protected void setProcessDefinitionProperty(T entity, ProcessDefinition processDefinition) {
        IntrospectionSupport.setProperty(entity, "processDefinition", processDefinition);
    }

    protected T createEntity(Exchange exchange, Object key) {
        return exchange.getContext().getInjector().newInstance(this.getEntityType());
    }

    @Override
    protected void processEntity(Exchange exchange, T entity) throws Exception {
        if (!(entity instanceof Processor)) {
            throw new IllegalArgumentException("No processor defined for this route");
        }
        Processor processor = (Processor)entity;
        processor.process(exchange);
    }

    protected String createFindByKeyQuery() {
        return "select x from " + this.getEntityType().getName() + " x where x." + this.getKeyPropertyName() + " = ?1";
    }
}

