/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.processor;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.bam.processor.NoCorrelationKeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BamProcessorSupport<T>
implements Processor {
    private static final transient Log log = LogFactory.getLog(BamProcessorSupport.class);
    private Class<T> entityType;
    private Expression<Exchange> correlationKeyExpression;
    private TransactionTemplate transactionTemplate;

    protected BamProcessorSupport(TransactionTemplate transactionTemplate, Expression<Exchange> correlationKeyExpression) {
        Type argumentType;
        ParameterizedType parameterizedType;
        Type[] arguments;
        this.transactionTemplate = transactionTemplate;
        this.correlationKeyExpression = correlationKeyExpression;
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && (argumentType = arguments[0]) instanceof Class) {
            this.entityType = (Class)argumentType;
        }
        if (this.entityType == null) {
            throw new IllegalArgumentException("Could not infer the entity type!");
        }
    }

    protected BamProcessorSupport(TransactionTemplate transactionTemplate, Expression<Exchange> correlationKeyExpression, Class<T> entitytype) {
        this.transactionTemplate = transactionTemplate;
        this.entityType = entitytype;
        this.correlationKeyExpression = correlationKeyExpression;
    }

    @Override
    public void process(final Exchange exchange) {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                try {
                    Object key = BamProcessorSupport.this.getCorrelationKey(exchange);
                    Object entity = BamProcessorSupport.this.loadEntity(exchange, key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Correlation key: " + key + " with entity: " + entity));
                    }
                    BamProcessorSupport.this.processEntity(exchange, entity);
                    return entity;
                }
                catch (Exception e) {
                    throw new RuntimeCamelException(e);
                }
            }
        });
    }

    public Expression<Exchange> getCorrelationKeyExpression() {
        return this.correlationKeyExpression;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    protected abstract void processEntity(Exchange var1, T var2) throws Exception;

    protected abstract T loadEntity(Exchange var1, Object var2);

    protected Object getCorrelationKey(Exchange exchange) throws NoCorrelationKeyException {
        Object value = this.correlationKeyExpression.evaluate(exchange);
        if (value == null) {
            throw new NoCorrelationKeyException(this, exchange);
        }
        return value;
    }
}

